#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "repertoire.h"
#include "attribute.h"
#include "utils.h"

u64 make_repertoire_strict(REPERTOIRE_VALUES *r_v,REPERTOIRE_PARAMS *r_p)
{
u64 set;
int size_in;
int size_random;
int i,k;

size_in=size(r_p->mask_in);
size_random=size(r_p->mask_random);
if(size_in==r_p->size)return r_p->mask_in;
if(size_in+size_random==r_p->size)return (r_p->mask_in | r_p->mask_random);
i=0;
for(k=0;(k<56)&&(i<r_v->size);k++){
	if(r_p->mask_random & (((u64)1)<<k)){
			r_v->data1[i]=k;
			i++;
			}
	}
set=r_p->mask_in;
while((i>0)&&(size(set)<r_p->size)){
	k=make_random_int(0,i);
	set=set | (((u64)1)<<r_v->data1[k]);
	i--;
	r_v->data1[k]=r_v->data1[i]; /* we are shrinking the set. 
	                                the order doesn't matter anyway */
	}
return set;
}

u64 make_repertoire_non_strict(REPERTOIRE_VALUES *r_v,REPERTOIRE_PARAMS *r_p)
{
u64 set;
int size_in;

size_in=size(r_p->mask_in);
if(size_in==r_p->size)return r_p->mask_in;
/* ... */
return make_repertoire_strict(r_v,r_p); /* nothing better for now */
}

u64 make_repertoire(REPERTOIRE_VALUES *r_v,REPERTOIRE_PARAMS *r_p)
{
u64 set;
int a,i;

if(r_p->size==0)return 0;
r_p->mask_random=r_p->mask_random & ((((u64)1)<<r_v->size)-1);
r_p->mask_in=r_p->mask_in & ((((u64)1)<<r_v->size)-1);
if(r_p->size>r_v->size)r_p->size=r_v->size;
if(r_p->size_strict)set=make_repertoire_strict(r_v,r_p);
	else set=make_repertoire_non_strict(r_v,r_p);
if(r_p->activated>=0)return REPERTOIRE(r_p->activated,set);
i=make_random_int(0,size(set))+1;
a=0;
while((i>0)){
	if(set & (1<<a))i--;
	a++;
	}
a--;
return REPERTOIRE(a,set);
}

void init_bias_values(REPERTOIRE_VALUES *r_v)
{
int i;
if(r_v->bias_values!=NULL)free(r_v->bias_values);
r_v->bias_values=do_alloc(r_v->size,sizeof(int));
for(i=0;i<r_v->size;i++)r_v->bias_values[i]=0;
if(r_v->data1!=NULL)free(r_v->data1);
r_v->data1=do_alloc(r_v->size,sizeof(int));
}


void dump_attr_rp(FILE *fout,REPERTOIRE_VALUES *r_v)
{
if(r_v->walk_bias)
	fprintf(fout,"\twalk\n");	
    else 
	fprintf(fout,"\tjump\n");	
fprintf(fout,"\tsize %d\n",r_v->size);
fprintf(fout,"\tbias_min %d\n",r_v->bias_min);
fprintf(fout,"\tbias_vol %d\n",r_v->bias_vol);
fprintf(fout,"\tbias_max %d\n",r_v->bias_max);
}

int get_repertoire_size(long index)
{
ATTRIBUTE *a;
a=get_attribute(index);
if(a==NULL)return -1;
if(a->type!=TYPE_REPERTOIRE)return -1;
return a->param.rep.size;
}

void evolve_repertoire(REPERTOIRE_VALUES *r_v)
{
int i;
for(i=0;i<r_v->size;i++){
	if(make_random_int(0,10000)<r_v->bias_vol){
		if(r_v->walk_bias){
			r_v->bias_values[i]+=make_random_int(-1,2);
			if(r_v->bias_values[i]<r_v->bias_min)r_v->bias_values[i]=r_v->bias_min;
			if(r_v->bias_values[i]>r_v->bias_max)r_v->bias_values[i]=r_v->bias_max;
			}else
			r_v->bias_values[i]=make_random_int(r_v->bias_min,r_v->bias_max+1);
		}
	}
}
